/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.earth.util;

import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.ui.bonsai.config.BonsaiConfigException;
import com.ibm.hwmca.ui.bonsai.config.ResourcesNodeConfigBean;
import com.ibm.hwmca.ui.bonsai.config.WorkareaConfigBean;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import com.ibm.hwmca.ui.bonsai.earth.ResourceMOTreeNode;
import com.ibm.hwmca.ui.bonsai.earth.util.AbstractNodeRetriever;
import com.ibm.hwmca.ui.bonsai.util.SortedList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class AbstractMONodeRetriever
extends AbstractNodeRetriever {
    public List getNodes(ResourcesNodeConfigBean configBean, BonsaiTreeNode parent, WorkareaConfigBean defaultWorkarea, Set filters) throws BonsaiConfigException {
        Map params = configBean.getNodeRetrieverParameters();
        String colNames = (String)params.get("column_properties");
        String propNames = (String)params.get("listener_properties");
        List columns = colNames == null ? null : this.getDeclaredStringFields(colNames);
        HashSet properties = propNames == null ? null : new HashSet(this.getDeclaredStringFields(propNames));
        SortedList nodes = new SortedList(ResourceMOTreeNode.getComparator());
        Iterator i = this.getShortIds(parent, params);
        while (i.hasNext()) {
            nodes.add(new ResourceMOTreeNode(configBean, (String)i.next(), columns, properties, parent, defaultWorkarea, filters));
        }
        return nodes;
    }

    protected abstract Iterator getShortIds(BonsaiTreeNode var1, Map var2) throws BonsaiConfigException;

    protected ClassId[] getClassIds(String classes) {
        return this.getClassIds(classes, ";");
    }

    protected ClassId[] getClassIds(String classes, String delim) {
        StringTokenizer tokens = new StringTokenizer(classes, delim);
        ClassId[] classIds = new ClassId[tokens.countTokens()];
        String fullyQualifiedClass = null;
        int index = 0;
        for (int i = 0; i < classIds.length; ++i) {
            fullyQualifiedClass = tokens.nextToken();
            index = fullyQualifiedClass.lastIndexOf(46);
            classIds[i] = new ClassId(fullyQualifiedClass.substring(0, index), fullyQualifiedClass.substring(index + 1));
        }
        return classIds;
    }

    protected void trimCollection(Collection objectIds, Set classes) {
        Iterator i = objectIds.iterator();
        while (i.hasNext()) {
            if (classes.contains(((ObjectId)i.next()).getFullClassName())) continue;
            i.remove();
        }
    }
}

